import sys
sys.setrecursionlimit(1 << 25)

def main():
    input_data = sys.stdin.read().strip().split()
    n = int(input_data[0])
    arr = input_data[1:]
    nums = [s for s in arr]

    parent = []
    parent_digit = []
    terminal_id = []  

    def new_node(p=-1, pd=None):
        children.append({})
        parent.append(p)
        parent_digit.append(pd)
        terminal_id.append(-1)
        return len(children) - 1

    root = new_node()

    node_of_index = [-1] * n  

    for i, s in enumerate(nums):
        cur = root
        for ch in s:
            d = ch 
            if d not in children[cur]:
                nxt = new_node(cur, d)
                children[cur][d] = nxt
            cur = children[cur][d]
        terminal_id[cur] = i
        node_of_index[i] = cur

    m = len(children)
    term_count = [0] * m

    stack = [(root, 0)]
    order = []
    while stack:
        v, state = stack.pop()
        if state == 0:
            stack.append((v, 1))
            for d, to in children[v].items():
                stack.append((to, 0))
        else:
            order.append(v)
            cnt = 1 if terminal_id[v] != -1 else 0
            for d, to in children[v].items():
                cnt += term_count[to]
            term_count[v] = cnt

    leaf_term_nodes = []
    for v in range(m):
        if terminal_id[v] != -1 and term_count[v] == 1:
            leaf_term_nodes.append(v)

    assigned = [False] * n
    groups = []

    for leaf in leaf_term_nodes:
        group = []
        v = leaf
        while v != -1:
            tid = terminal_id[v]
            if tid != -1 and not assigned[tid]:
                assigned[tid] = True
                group.append(tid)
            v = parent[v]
        groups.append(group)


    for i in range(n):
        if not assigned[i]:
            groups.append([i])
            assigned[i] = True


    k = len(groups)
    out_lines = [str(k)]
    for g in groups:
        out_lines.append(str(len(g)))
        out_lines.append(" ".join(nums[idx] for idx in g))
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    main()